<?php $__env->startSection('title'); ?> <?php if(isset($pageTitle)): ?> <?php echo e($pageTitle); ?> <?php endif; ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-body'); ?>
    <!-- Start page title -->
    <div class="qz-page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(isset($pageTitle) ? $pageTitle : ''); ?></h2>
                        <span class="sidebarToggler">
                            <i class="fa fa-bars d-lg-none d-block"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End page title -->
    <?php echo $__env->make('layout.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Start content area  -->
    <div class="qz-content-area">
        <div class="card add-category">
            <div class="card-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if(isset($user)): ?>
                                <?php echo e(Form::open(['route' => 'userUpdateProcess', 'files' => 'true'])); ?>

                            <?php else: ?>
                                <?php echo e(Form::open(['route' => 'userAddProcess', 'files' => 'true'])); ?>

                            <?php endif; ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('name') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('User Name')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="name" <?php if(isset($user)): ?> value="<?php echo e($user->name); ?>" <?php else: ?> value="<?php echo e(old('name')); ?>"
                                               <?php endif; ?> class="form-control" placeholder="User Name">
                                        <span class="text-danger"><strong><?php echo e($errors->first('name')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Email')); ?><span class="text-danger">*</span></label>
                                        <?php if(isset($user)): ?>
                                            <span class="form-control for-email"><?php echo e($user->email); ?></span>
                                        <?php else: ?>
                                            <input type="email" name="email" value="<?php echo e(old('email')); ?>" class="form-control" placeholder="Email Address">
                                        <?php endif; ?>
                                        <span class="text-danger"><strong><?php echo e($errors->first('email')); ?></strong></span>
                                    </div>
                                </div>
                                <?php if(empty($user)): ?>
                                    <div class="col-md-6">
                                        <div class="form-group <?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
                                            <label><?php echo e(__('Password')); ?><span class="text-danger">*</span></label>
                                            <input type="password" name="password" class="form-control" placeholder="Password">
                                            <span class="text-danger"><strong><?php echo e($errors->first('password')); ?></strong></span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group <?php echo e($errors->has('password_confirmation') ? ' has-error' : ''); ?>">
                                            <label><?php echo e(__('Confirm Password')); ?><span class="text-danger">*</span></label>
                                            <input type="password" name="password_confirmation" class="form-control" placeholder="Confirm Password">
                                            <span class="text-danger"><strong><?php echo e($errors->first('password_confirmation')); ?></strong></span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('role') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Role')); ?><span class="text-danger">*</span></label>
                                        <div class="qz-question-category">
                                            <select name="role" class="form-control">
                                                <option value=""><?php echo e(__('Select Role')); ?></option>
                                                <?php $__currentLoopData = role(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if(isset($user) && ($user->role == $key)): ?> selected <?php elseif((old('role') != null) &&
                                                    (old('role') == $key)): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <span class="text-danger"><strong><?php echo e($errors->first('role')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('country') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Country')); ?><span class="text-danger">*</span></label>
                                        <div class="qz-question-category">
                                            <select name="country" class="form-control">
                                                <option value=""><?php echo e(__('Select Country')); ?></option>
                                                <?php $__currentLoopData = country(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if(isset($user) && ($user->country == $key)): ?> selected <?php elseif((old('country') != null)
                                                     && (old('country') == $key)): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <span class="text-danger"><strong><?php echo e($errors->first('country')); ?></strong></span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <?php if(isset($user)): ?>
                                        <input type="hidden" name="edit_id" value="<?php echo e($user->id); ?>">
                                        <?php endif; ?>
                                    <button type="submit" class="btn btn-primary btn-block add-category-btn">
                                        <?php if(isset($user)): ?> <?php echo e(__('Update')); ?> <?php else: ?> <?php echo e(__('Add New')); ?> <?php endif; ?>
                                    </button>
                                </div>
                            </div>
                            <?php echo e(Form::close()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End content area  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ayara/resources/views/admin/user/add-edit.blade.php ENDPATH**/ ?>